/* ...............................................................

	WindowColors
	Copyright 1997-8 Steve Klingsporn <moofie@pobox.com>
	Based on WindowShade by Marco Nelissen <marcone@xs4all.nl>
	
		File:	WindowColorsPanel.h
	
	Contains:	Class definition and includes for base panel
				BView subclass.
	
	   Notes:	None.
	   
   ............................................................... */

#ifndef _WINDOW_COLORS_PANEL_H
#define _WINDOW_COLORS_PANEL_H

#ifndef _COLOR_LABEL_H
#include "ColorLabel.h"
#endif

#ifndef _COLOR_PICKER_H
#include "ColorPicker.h"
#endif

#ifndef _SEPARATOR_LINE_H
#include "SeparatorLine.h"
#endif

#ifndef _WINDOW_VIEW_H
#include "WindowView.h"
#endif

#ifndef _WINDOW_COLORS_H
#include "WindowColors.h"
#endif

#ifndef _WINDOWCOLORS_APPLICATION_H
#include "WindowColorsApplication.h"
#endif

#ifndef _VIEW_H
#include <View.h>
#endif

#ifndef _MESSAGE_FILTER_H
#include <MessageFilter.h>
#endif


/* ...............................................................
	Constants
	Constants used by the WindowColorsPanel object, including
	an array of default window_color values (valid for PR2).
   ............................................................... */

const float			LEFT_ALIGNMENT_MARGIN = 20;
const BRect			TABBED_WINDOW_FRAME = BRect(LEFT_ALIGNMENT_MARGIN,
												20, 260, 160);
const BRect			MODAL_WINDOW_FRAME = BRect(270, 39, 410, 140);
const BRect			SEPARATOR_LINE_FRAME = BRect(LEFT_ALIGNMENT_MARGIN, 
												 175, 408, 177);
const BRect     	COLOR_CONTROL_FRAME = BRect(LEFT_ALIGNMENT_MARGIN, 
											    192, 408, 292);
const BPoint		BUTTON_RIGHT_EDGE = BPoint(408, 301);
const float			BUTTON_SPACER = 9;
const BRect			TITLE_TAB_LABEL_FRAME = BRect(15, 31, 120, 56);
const BRect			FRAME_LABEL_FRAME = BRect(127, 31, 210, 56);
const BRect			MODAL_FRAME_LABEL_FRAME = BRect(15, 12, 120, 37);


/* ...............................................................
	WindowColorsPanel
	The background panel view in the application.
   ............................................................... */

class ColorLabel;
class WindowView;
class ColorPicker;
class SeparatorLine;

class WindowColorsPanel : public BView
{
	public:
							WindowColorsPanel(BRect frame);
			virtual			~WindowColorsPanel();
			
			void			AttachedToWindow();
			void			AllAttached();
			void			Show();
			void			Draw(BRect updateRect);
			void			MessageReceived(BMessage *message);
						
			void			GetDefaultWindowColors(bool refresh = false);
			void			GetSystemWindowColors(bool refresh = false);
			void			SetSystemWindowColors(bool refresh = true);

	ColorPicker				*GetColorPicker();
	ColorLabel				*FocusedColorLabel();
	
			BBitmap			*Bitmap(window_bitmap which);
			
			rgb_color		Color(window_color which);
			void			SetColor(window_color which, 
								 	 rgb_color color);
								 	 								 
			WindowView		*ActiveWindowView();
			void			SetActiveWindowView(WindowView *view);
			
	private:
		
		rgb_color			_colors[NUM_WINDOW_COLORS];
		BBitmap				*_bitmaps[4];
		WindowView			*_windowView;
		WindowView			*_modalWindowView;
		SeparatorLine		*_separatorLine;
		BButton				*_setButton;
		BButton				*_defaultsButton;
		BButton				*_revertButton;
		BButton				*_aboutButton;
		ColorPicker			*_colorPicker;
		WindowView			*_activeWindowView;
		bool				_synced;	/* bad design */
};


/* ...............................................................
	ColumnLabelFilter
	Filters B_MOUSE_DOWN objects from one of our BStringView
	column labels, and sets the focus to the first entry in
	the correct column, ignoring the message.
   ............................................................... */

class ColumnLabelFilter : public BMessageFilter
{
	public:
							ColumnLabelFilter();
			
			filter_result	Filter(BMessage *message, 
								   BHandler **target);
};

#endif